// ======== ======== ======== ======== ======== ======== ======== ========
//
//	title : classMake[ input.cpp ]					Auter : KENSUKE WATANABE
//													Data  : 2016/08/29
//
// -------- -------- -------- -------- -------- -------- -------- --------
//Update : 2016/08/29
//
// ======== ======== ======== ======== ======== ======== ======== ========
#include "inputJoyStick.h"

//=============================================================================
// ÓIϐ
//=============================================================================
LPDIRECTINPUTDEVICE8 CInputJoyStick::m_pDIDevice = nullptr;

//=============================================================================
// WCXeBbN̏
//=============================================================================
HRESULT CInputJoyStick::Init(HINSTANCE hInstance, HWND hWnd)
{
	// ȅ(foCX̍쐬)
	CInput::Init(hInstance);

	HRESULT hr;
	// foCX̍쐬
	if (FAILED(m_pDInput->EnumDevices(DI8DEVCLASS_GAMECTRL, EnumJoysticksCallback, nullptr, DIEDFL_ATTACHEDONLY)) || m_pDIDevice == nullptr)
	{
		//	MessageBox(hWnd, "Rg[܂łB", "xI", MB_ICONWARNING);
		return E_FAIL;
	}

	m_bJoystick = true;	//WCXeBbNgp

						// f[^tH[}bgݒ
	if (FAILED(m_pDIDevice->SetDataFormat(&c_dfDIJoystick)))
	{
		MessageBox(hWnd, "WCXebÑf[^tH[}bgݒł܂łB", "xI", MB_ICONWARNING);
		return E_FAIL;
	}

	// [hݒitHAOEhr[hj
	if (FAILED(m_pDIDevice->SetCooperativeLevel(hWnd, (DISCL_FOREGROUND | DISCL_NONEXCLUSIVE))))
	{
		MessageBox(hWnd, "WCXeBbN̋[hݒł܂łB", "xI", MB_ICONWARNING);
		return E_FAIL;
	}

	//foCX̔\͎擾
	m_diDevCaps.dwSize = sizeof(DIDEVCAPS);
	if (FAILED(m_pDIDevice->GetCapabilities(&m_diDevCaps)))
	{
		MessageBox(hWnd, "WCXeBbN̔\͎擾ł܂łB", "xI", MB_ICONWARNING);
		return E_FAIL;
	}

	//͈̔͐ݒ
	if (FAILED(m_pDIDevice->EnumObjects(EnumAxisCallback, (void*)hWnd, DIDFT_AXIS)))
	{
		MessageBox(hWnd, "WCXeBbN̐ݒ肪ł܂łB", "xI", MB_ICONWARNING);
		return E_FAIL;
	}

	// WCXeBbNւ̃ANZXl(͐Jn) foCXɂĂ͉ɍsȂĂ͂Ȃ
	if (FAILED(m_pDIDevice->Poll()))
	{
		while (m_pDIDevice->Acquire() == DIERR_INPUTLOST)
		{
			hr = m_pDIDevice->Acquire();
		}
	}

	return S_OK;
}

//=============================================================================
// WCXeBbÑfoCX
//=============================================================================
BOOL CALLBACK CInputJoyStick::EnumJoysticksCallback(const DIDEVICEINSTANCE *pdidInstance, void *pContext)
{
	UNREFERENCED_PARAMETER(pContext);

	static GUID pad_discrimination;					// foCX̎ʎqi[
	DIDEVCAPS diDevCaps;							// WCpbh̔\͏

	if (pad_discrimination == pdidInstance->guidInstance)
	{
		return DIENUM_CONTINUE;
	}

	// 񋓂ꂽWCXeBbNւ̃C^[tFCX擾
	if (FAILED(m_pDInput->CreateDevice(pdidInstance->guidInstance, &m_pDIDevice, nullptr)))
	{
		return DIENUM_CONTINUE;
	}

	// WCpbh̔\͂𒲂ׂ
	diDevCaps.dwSize = sizeof(DIDEVCAPS);
	if (FAILED(m_pDIDevice->GetCapabilities(&diDevCaps)))
	{
		if (m_pDIDevice != nullptr)
		{
			m_pDIDevice->Release();
			m_pDIDevice = nullptr;
		}
		return DIENUM_CONTINUE;
	}

	// foCX̎ʎqۑ
	pad_discrimination = pdidInstance->guidInstance;

	// ̃foCXg(񋓂I)
	return DIENUM_STOP;
}

//=============================================================================
// ̐ݒ
//=============================================================================
BOOL CALLBACK CInputJoyStick::EnumAxisCallback(const DIDEVICEOBJECTINSTANCE *pdidoi, void* pContext)
{
	UNREFERENCED_PARAMETER(pContext);

	DIPROPRANGE diprg;

	diprg.diph.dwSize = sizeof(DIPROPRANGE);
	diprg.diph.dwHeaderSize = sizeof(DIPROPHEADER);
	diprg.diph.dwHow = DIPH_BYID;
	diprg.diph.dwObj = pdidoi->dwType;
	diprg.lMin = 0 - 1000;
	diprg.lMax = 0 + 1000;
	if (FAILED(m_pDIDevice->SetProperty(DIPROP_RANGE, &diprg.diph)))
	{
		return DIENUM_STOP;
	}

	return DIENUM_CONTINUE;
}

//=============================================================================
// WCXeBbN̏I
//=============================================================================
void CInputJoyStick::Uninit(void)
{
	if (m_pDIDevice)
	{// WCXeBbNւ̃ANZXJ(͐I)
		m_pDIDevice->Unacquire();

		m_pDIDevice->Release();
		m_pDIDevice = nullptr;
	}
}

//=============================================================================
// WCXeBbN̍XV
//=============================================================================
void CInputJoyStick::Update(void)
{
	if (m_bstick == true)
	{
		DIJOYSTATE joyState;

		m_pDIDevice->Poll();

		// foCXf[^擾
		if (SUCCEEDED(m_pDIDevice->GetDeviceState(sizeof(DIJOYSTATE), &joyState)))
		{
			for (int nCnKey = 0; nCnKey < NUM_BUT_MAX; nCnKey++)
			{
				// L[vXۑ
				m_aStateTrigger[nCnKey] = (m_aState[nCnKey] ^ joyState.rgbButtons[nCnKey]) & joyState.rgbButtons[nCnKey];	//gK[ۑ
				m_aStateRelease[nCnKey] = (m_aState[nCnKey] ^ joyState.rgbButtons[nCnKey]) & ~joyState.rgbButtons[nCnKey];	//[Xۑ

																															//L[s[g̐ (s&0x80)
				if (joyState.rgbButtons[nCnKey])
				{//L[Ă
					if (m_aStateRepeatCnt[nCnKey] < COUNT_WAIT_REPEAT)
					{//s[gJEgɒBĂȂ
						m_aStateRepeatCnt[nCnKey]++;
						if (m_aStateRepeatCnt[nCnKey] == 1 || m_aStateRepeatCnt[nCnKey] >= COUNT_WAIT_REPEAT)
						{//͂߂AɒBƂ
							m_aStateRepeat[nCnKey] = joyState.rgbButtons[nCnKey];
						}
						else
						{//ɒB܂ł̊
							m_aStateRepeat[nCnKey] = 0;
						}
					}
				}
				else
				{//L[ĂȂ
					m_aStateRepeat[nCnKey] = 0;
					m_aStateRepeatCnt[nCnKey] = 0;
				}

				m_aState[nCnKey] = joyState.rgbButtons[nCnKey];	//݂̃L[ۑ
			}
			// AiOXeBbNۑ
			m_nLx = joyState.lX;
			m_nLy = joyState.lY;
			m_nLz = joyState.lZ;
			m_nLRz = joyState.lRz;
		}
		else
		{//sĂANZXƂɂ
			m_pDIDevice->Acquire();
		}
	}
}